import User from "../models/User.js";

export const registerUser = async (req, res) => {
  try {
    const { username, email, password } = req.body;
    
    // Validasi input sederhana
    if (!username || !email || !password) {
      return res.status(400).json({ msg: "Semua field harus diisi!" });
    }
    
    // Cek apakah email sudah terdaftar
    const existingUser = await User.findOne({ where: { email } });
    if (existingUser) {
      return res.status(400).json({ msg: "Email sudah terdaftar!" });
    }
    
    // Simpan user baru ke database
    const newUser = await User.create({
      username,
      email,
      password, // belum di-hash
    });
    
    console.log(`✅ User baru dibuat: ${newUser.username}`);
    // Kirim response
    return res.status(201).json({
      msg: "Registrasi berhasil!"
    });
  } catch (error) {
    console.error("❌ Error registrasi:", error.message);
    return res.status(500).json({ msg: "Terjadi kesalahan server" });
  }
};

//login
export const loginUser = async (req, res) => {
  try {
    const { email, password } = req.body;
    if(!email||!password) return res.status(401).json({msg: "Harap isi bidang kosong!"})
    // Cek apakah email ada
    const user = await User.findOne({ where: { email } });
    if (!user) {
      return res.status(404).json({ msg: "Email tidak ditemukan" });
    }
    
    // Cek password (belum hash)
    if (user.password !== password) {
      return res.status(401).json({ msg: "Password salah" });
    }
    
    // Simpan data user ke session
    req.session.user = {
      id: user.id,
      username: user.username,
      email: user.email,
    };
    
    res.status(200).json({ msg: "Login berhasil", user: req.session.user });
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "Terjadi kesalahan server" });
  }
};

//logout
export const logoutUser = (req, res) => {
  req.session.destroy((err) => {
    if (err) return res.status(500).json({ msg: "Gagal logout" });
    res.status(200).json({ msg: "Berhasil logout" });
  });
};