import { DataTypes } from "sequelize";
import { db } from "../config/database.js";

const User = db.define("User", {
  
  username: {
    type: DataTypes.STRING(50),
    allowNull: false,
  },
  email: {
    type: DataTypes.STRING(100),
    allowNull: false,
    unique: true,
    validate: {
      isEmail: true, // validasi otomatis email
    },
  },
  password: {
    type: DataTypes.STRING,
    allowNull: false,
  },
}, {
  tableName: "users",     // nama tabel di database
  timestamps: true,       // otomatis tambah createdAt & updatedAt
});

export default User;