import express from "express";

import {
  registerUser,
  loginUser,
  logoutUser
} from "../controllers/userController.js";

import { 
  addContent,
  renderContent,
  createPayment,
  cekPayment
} from "../controllers/contentController.js";

import { isLogin } from "../middlewares/middleware.js";

const router = express.Router();

router.get("/", (req,res)=>{
  res.render("login")
})

router.get("/dashboard", isLogin, (req,res)=>{
  res.render("dashboard")
})
router.get("/:slug", renderContent)

router.post("/register", registerUser);
router.post("/content", isLogin, addContent);
router.post("/login", loginUser);
router.post("/pay-vip", createPayment);
router.post("/logout", logoutUser);
router.post("/cek-status", cekPayment);

export default router;